/*
   fdio_reg.h - register definitions driver for SoftLab-NSK FDIO IP core

   Copyright (C) 2017 - 2024 SoftLab-NSK <forward@softlab.tv>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FDIO_REG_H
#define FDIO_REG_H

#include <linux/types.h>
#include <linux/io.h>

#define __read_reg(csr, addr) ioread32(&csr[addr])
#define __write_reg(csr, addr, v) iowrite32(v, &csr[addr])

typedef struct _FDIO_VDMA {
	uint32_t _unused3000 : 31;
	uint32_t enable : 1;
} __attribute__((packed)) FDIO_VDMA;

#define FDIO_VDMA_A (0x00)

__always_inline FDIO_VDMA FDIO_VDMA_R(uint32_t *csr)
{
	uint32_t r = __read_reg(csr, FDIO_VDMA_A);
	return *((FDIO_VDMA *)&r);
}

__always_inline void FDIO_VDMA_W(uint32_t *csr, FDIO_VDMA v)
{
	__write_reg(csr, FDIO_VDMA_A, *((uint32_t *)&v));
}

typedef struct _FDIO_VDMADescriptor {
	uint32_t address : 32;
} __attribute__((packed)) FDIO_VDMADescriptor;

#define FDIO_VDMADescriptor_A (0x01)

__always_inline FDIO_VDMADescriptor FDIO_VDMADescriptor_R(uint32_t *csr)
{
	uint32_t r = __read_reg(csr, FDIO_VDMADescriptor_A);
	return *((FDIO_VDMADescriptor *)&r);
}

__always_inline void FDIO_VDMADescriptor_W(uint32_t *csr, FDIO_VDMADescriptor v)
{
	__write_reg(csr, FDIO_VDMADescriptor_A, *((uint32_t *)&v));
}

#define FDIO_IRQEnable_A (0x04)
#define FDIO_IRQFlags_A (0x05)

typedef struct _FDIO_StaticVersion {
	uint32_t revision : 16;
	uint32_t major : 8;
	uint32_t __unused2724 : 4;
	uint32_t project : 4;
} __attribute__((packed)) FDIO_StaticVersion;

#define FDIO_StaticVersion_A (0x7F)

__always_inline FDIO_StaticVersion FDIO_StaticVersion_R(uint32_t *csr)
{
	uint32_t r = __read_reg(csr, FDIO_StaticVersion_A);
	return *((FDIO_StaticVersion *)&r);
}

#endif
