/*
   forward-alsa-utils.h - ALSA utilities for SoftLab-NSK Forward video boards

   Copyright (C) 2017 - 2023 Konstantin Oblaukhov <oblaukhov@sl.iae.nsk.su>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_ALSA_UTILS_H
#define FORWARD_ALSA_UTILS_H

#include "forward-alsa.h"
#include "forward-alsa-io.h"

snd_pcm_sframes_t forward_alsa_input_decode_smpte272(struct forward_alsa_io *io, const u16 *buffer,
						     size_t size);

snd_pcm_sframes_t forward_alsa_input_decode_smpte299(struct forward_alsa_io *io, const u16 *buffer,
						     size_t size);

snd_pcm_sframes_t forward_alsa_input_decode_hdmi(struct forward_alsa_io *io, const uint8_t *buf,
						 size_t size);

bool forward_alsa_input_extract_status_hdmi(struct forward_alsa_io *io, const uint8_t *buf,
					    size_t size);

snd_pcm_sframes_t forward_alsa_output_encode_raw(struct forward_alsa_io *io,
						 snd_pcm_sframes_t delta);

#endif // FORWARD_ALSA_UTILS_H
