/*
   forward-v4l2-genlock.h - v4l2 genlock for SoftLab-NSK Forward video boards

   Copyright (C) 2017 - 2023 Konstantin Oblaukhov <oblaukhov@sl.iae.nsk.su>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_V4L2_GENLOCK_H
#define FORWARD_V4L2_GENLOCK_H

#include "forward.h"
#include "forward-v4l2.h"
#include "forward-v4l2-timings.h"
#include "forward-v4l2-ioctl.h"

struct forward_v4l2_genlock {
	struct forward_v4l2 *v4l2;

	enum v4l2_forward_genlock_state state;
	enum v4l2_forward_genlock_source source, new_source;

	struct forward_v4l2_timings in_timings, timings;
	bool in_timings_valid;

	struct forward_irq_listener listener;
	spinlock_t lock;

	u32 ref_offset;
	u32 stable_ref_count;
	u32 last_frame_time;
	u64 frame_sequence;

	int user_offset, new_user_offset;
};

int forward_v4l2_genlock_init(struct forward_v4l2_genlock *gl);
void forward_v4l2_genlock_deinit(struct forward_v4l2_genlock *gl);

void forward_v4l2_genlock_process(struct forward_v4l2_genlock *gl);

#endif // FORWARD_V4L2_GENLOCK_H
