#pragma once

#include <alsa/asoundlib.h>
#include <cstdint>
#include <memory>
#include <string>

//! Small C++ wrapper around ALSA device
class ALSADevice {
public:
    //! Create and open ALSA device from name (hw:X,Y)
    ALSADevice(std::string& name, snd_pcm_stream_t stream);

    //! Check device is open
    bool isOpen() const;
    //! There was error during last operation
    bool isError() const;
    //! Error code
    int error() const;
    //! Error description
    std::string errorString() const;
    //! ALSA handle
    std::shared_ptr<snd_pcm_t> pcm() const;

private:
    ALSADevice(ALSADevice const&) = delete;
    ALSADevice& operator=(ALSADevice const&) = delete;

    std::shared_ptr<snd_pcm_t> m_pcm;
    int m_lastError = 0;
};
