#pragma once

#include "Board.hpp"
#include "V4L2Device.hpp"

#include <cstdint>
#include <memory>
#include <string>

class FD2110Helper {
public:
    FD2110Helper(const std::string& board);
    virtual ~FD2110Helper();

    int enableStream(int stream);

    std::string getVideoDevice(int stream);
    std::string getAudioDevice(int stream);

    int setVideoAddress(V4L2Device& dev, const std::string& videoAddr, uint16_t videoPort);
    int setComplexAudioAddress(
        V4L2Device& dev, const std::string& audioAddress, uint16_t audioPort);

    int joinMulticast(int stream, const std::string& addr, uint16_t port);

private:
    std::unique_ptr<Board> m_board;
    int m_sock = -1;
};