#include <cstdint>
#include <map>
#include <vector>

//! Class providing parser for RTP packets from FD2110
class RTPParser {
public:
    //! Internal representation of RTP packet header
    struct RTPHeader {
        uint8_t rtpHeader[12];
        uint16_t length;
        uint8_t tag;
        uint32_t offset;
    };
    RTPParser();

    void parse(uint8_t* data, int size);
    int extractST2110AudioPCM24(uint32_t* samples, int channels, int maxsamples, uint8_t pt);

private:
    std::map<uint8_t, std::vector<uint8_t>> m_data;
    std::map<uint8_t, std::vector<RTPHeader>> m_packets;
};
