#include "Board.hpp"

#include <iostream>

/*!
 * \dir ./
 * This example shows how to use \ref Board to switch pins between input or output
 */

void showInfo(const Board& b)
{
    std::vector<Board::IOMode> modes = b.ioMode();
    auto info = b.info();

    std::cout << "Board " << info.name << " (" << info.path << "): " << std::endl;
    for (int i = 0; i < info.ioCount; i++) {
        std::cout << "\tIO" << (i + 1) << ": ";
        switch (modes[i]) {
        case Board::IOMode::Input:
            std::cout << "In ";
            break;
        case Board::IOMode::Output:
            std::cout << "Out";
            break;
        default:
            std::cout << "Inv";
            break;
        }

        std::cout << " " << info.videoDevs[i] << " " << info.vbiDevs[i] << " " << info.audioDevs[i]
                  << std::endl;
    }
}

int main(int argc, char** argv)
{
    std::vector<Board::Info> boards = Board::enumerate();

    for (auto& bi : boards) {
        if (bi.type != Board::Info::FD788)
            continue;

        Board board(bi);
        std::vector<Board::IOMode> oldModes = board.ioMode();

        showInfo(board);

        std::cout << "Switching to IIIIIIII, ";
        int result = board.configureIOMode({ Board::IOMode::Input, Board::IOMode::Input,
            Board::IOMode::Input, Board::IOMode::Input, Board::IOMode::Input, Board::IOMode::Input,
            Board::IOMode::Input, Board::IOMode::Input });
        std::cout << " result = " << result << std::endl;

        showInfo(board);

        std::cout << "Switching back, ";
        result = board.configureIOMode(oldModes);
        std::cout << " result = " << result << std::endl;
    }
}
