/*
   forward-splicer-asi.h - DVB-ASI utilities for SoftLab-NSK Forward video boards

   Copyright (C) 2017 - 2024 SoftLab-NSK <forward@softlab.tv>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_SPLICER_ASI_H
#define FORWARD_SPLICER_ASI_H

#include "forward-splicer.h"

size_t forward_splicer_process_asi(struct forward_splicer_io *io, const u8 *hw_in, u8 *hw_out,
				   size_t hw_size);

void forward_splicer_unpack10b16b(const u8 *in, u8 *out, int words);
void forward_splicer_pack16b10b(const u8 *in, u8 *out, int words);

#endif // FORWARD_SPLICER_ASI_H
