/*
   forward-splicer.h - splicer driver for SoftLab-NSK Forward boards

   Copyright (C) 2017 - 2024 SoftLab-NSK <forward@softlab.tv>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef FORWARD_SPLICER_H
#define FORWARD_SPLICER_H

#include "forward.h"
#include "forward-irq.h"

struct forward_splicer;
struct forward_splicer_dev_ops;

struct forward_splicer_io {
	struct forward_splicer *splicer;

	struct mutex lock;

	int in_index, out_index;
	u8 *in_buffer, *out_buffer, *tmp_buffer;

	unsigned int irq_counter;
	bool locked, asi_detected;
	bool fec;

	bool streaming;
	bool in_en, out_en;
	bool bypass;

	u8 *stream_buffer;
	size_t stream_buffer_size;
	size_t stream_rd_pos, stream_wr_pos;

	struct cdev cdev;
	struct device *dev;
	dev_t dev_num;

	struct task_struct *thread;
};

struct forward_splicer {
	struct forward_dev *dev;
	const struct forward_splicer_dev_ops *ops;
	struct forward_splicer_io *io;
};

struct forward_splicer_dev_ops {
	forward_irq_t (*irq_mask)(const struct forward_splicer_io *io);
	bool (*irq_info)(struct forward_splicer_io *io, const forward_irq_t *irq, bool *in,
			 int *in_buffer, size_t *in_size, u32 *in_timestamp, bool *out,
			 int *out_buffer, size_t *out_size, u32 *out_timestamp);

	u32 (*buffer_map_address)(const struct forward_splicer_io *io, int buffer, bool in);

	void (*configure_io)(const struct forward_splicer_io *io);
	void (*io_state)(const struct forward_splicer_io *io, bool *asi_present);
	void (*shift_io)(const struct forward_splicer_io *io, s32 delta);
	void (*toggle_streaming)(const struct forward_splicer_io *io, bool enable);
	void (*toggle_bypass)(const struct forward_splicer_io *io, bool bypass,
			      unsigned int timeout_us);

	int num_io;
	int num_in_buffers, num_out_buffers;
	size_t buffer_in_size, buffer_out_size;
};

#endif
